// let url = "http://127.0.0.1"
let url = "https://www.mudi.pics"
const STORE_URL = "https://chromewebstore.google.com/detail/lightdownload/bagfjpcfejdcfnhckcjcpekcjbencfeb";

// Supported languages configuration
const supportedLangs = [
    'nl', 'vi', 'es', 'pt', 'de', 'fr', 'it', 'no', 'fi', 'sv', 'da', 'el', 'tr', 'ru', 'hi', 'th', 'ko', 'ro', 'pl', 'zh-TW', 'zh-CN', 'zh', 'ga', 'et', 'bg', 'cs', 'ms', 'sk', 'hu', 'id', 'fil', 'pt-BR', 'pt-PT', 'ja'
];

// Simple translation map (fallback to English)
const translations = {
    'default': {
        minSize: 'Min Size:', visitSite: 'Visit mudi.pics', downloadPrefix: 'Download on', empty: 'No videos detected on this page yet.<br>Try playing the video directly.',
        download: 'Download', copy: 'Copy', open: 'Open', copied: 'Copied!', copy_link: 'Copy Link', open_new_tab: 'Open in New Tab', m3u8: 'M3U8 Stream', video: 'Video File',
        paste_url: 'Paste video or M3U8 URL here...',
        invalid_url: 'Please enter a valid URL',
        rate_us: 'Rate Us',
        rating_title: 'Enjoying LightDownload?',
        rating_text: 'Support us by giving a 5-star rating on Chrome Store!',
        rate_now: 'Rate Now',
        maybe_later: 'Maybe Later'
    },
    'zh-TW': {
        minSize: '最小尺寸:', visitSite: '訪問 mudi.pics', downloadPrefix: '下載於', empty: '尚未在此頁面檢測到影片。<br>請嘗試直接播放影片。',
        download: '直接下載', copy: '複製', open: '打開', copied: '已複製！', copy_link: '複製連結', open_new_tab: '在新分頁中打開', m3u8: 'M3U8 串流', video: '影片文件',
        paste_url: '在此處粘貼影片或 M3U8 連結...',
        invalid_url: '請輸入有效的連結',
        rate_us: '給個好評',
        rating_title: '喜歡使用 LightDownload 嗎？',
        rating_text: '在 Chrome 商店給我們一個五星好評吧！',
        rate_now: '現在去好评',
        maybe_later: '以後再說'
    },
    'zh-CN': {
        minSize: '最小尺寸:', visitSite: '访问 mudi.pics', downloadPrefix: '下载于', empty: '尚未在此页面检测到视频。<br>请尝试直接播放视频。',
        download: '直接下载', copy: '复制', open: '打开', copied: '已复制！', copy_link: '复制链接', open_new_tab: '在新标签页中打开', m3u8: 'M3U8 串流', video: '视频文件',
        paste_url: '在此处粘贴视频或 M3U8 地址...',
        invalid_url: '请输入有效的地址',
        rate_us: '给个好评',
        rating_title: '喜欢使用 LightDownload 吗？',
        rating_text: '在 Chrome 商店给我们一个五星好评吧！',
        rate_now: '现在去好评',
        maybe_later: '以后再说'
    },
    'zh': {
        minSize: '最小尺寸:', visitSite: '访问 mudi.pics', downloadPrefix: '下载于', empty: '尚未在此页面检测到视频。<br>请尝试直接播放视频。',
        download: '直接下载', copy: '复制', open: '打开', copied: '已复制！', copy_link: '复制链接', open_new_tab: '在新标签页中打开', m3u8: 'M3U8 串流', video: '视频文件',
        paste_url: '在此处粘贴视频 or M3U8 地址...',
        invalid_url: '请输入有效的地址',
        rate_us: '给个好评',
        rating_title: '喜欢使用 LightDownload 吗？',
        rating_text: '在 Chrome 商店给我们一个五星好评吧！',
        rate_now: '现在去好评',
        maybe_later: '以后再说'
    },
    'es': {
        minSize: 'Tam. mín:', visitSite: 'Visitar mudi.pics', downloadPrefix: 'Descargar en', empty: 'No se detectaron videos.<br>Intenta reproducir el video.',
        download: 'Descargar', copy: 'Copiar', open: 'Abrir', copied: '¡Copiado!', copy_link: 'Copiar enlace', open_new_tab: 'Abrir en nueva pestaña', m3u8: 'Streaming M3U8', video: 'Archivo de video',
        paste_url: 'Pega la URL del video o M3U8 aquí...',
        invalid_url: 'Por favor, introduce una URL válida',
        rate_us: 'Danos tu opinión',
        rating_title: '¿Te gusta LightDownload?',
        rating_text: '¡Apóyanos con una calificación de 5 estrellas!',
        rate_now: 'Calificar ahora',
        maybe_later: 'Quizás más tarde'
    },
    'ja': {
        minSize: '最小サイズ:', visitSite: 'mudi.picsを訪問', downloadPrefix: 'でダウンロード', empty: '動画が検出されませんでした。<br>動画を再生してみてください。',
        download: 'ダウンロード', copy: 'コピー', open: '開く', copied: 'コピーしました！', copy_link: 'リンクをコピー', open_new_tab: '新しいタブで開く', m3u8: 'M3U8 ストリーム', video: '動画ファイル',
        paste_url: '動画または M3U8 の URL をここに貼り付け...',
        invalid_url: '有効なURLを入力してください',
        rate_us: '評価する',
        rating_title: 'LightDownload をお楽しみいただけていますか？',
        rating_text: 'Chrome ストアで 5 つ星の評価をお願いします！',
        rate_now: '今すぐ評価',
        maybe_later: 'また後で'
    },
    'nl': {
        minSize: 'Min. grootte:', visitSite: 'Bezoek mudi.pics', downloadPrefix: 'Download op', empty: 'Nog geen video\'s gedetecteerd op deze pagina.<br>Probeer de video direct af te spelen.',
        download: 'Downloaden', copy: 'Kopiëren', open: 'Openen', copied: 'Gekopieerd!', copy_link: 'Link kopiëren', open_new_tab: 'Openen in nieuw tabblad', m3u8: 'M3U8 Stream', video: 'Videobestand',
        paste_url: 'Plak video of M3U8 URL hier...',
        invalid_url: 'Voer een geldige URL in',
        rate_us: 'Beoordeel ons',
        rating_title: 'Geniet je van LightDownload?',
        rating_text: 'Steun ons met een 5-sterrenbeoordeling!',
        rate_now: 'Nu beoordelen',
        maybe_later: 'Misschien later'
    },
    'vi': {
        minSize: 'Dung lượng tối thiểu:', visitSite: 'Truy cập mudi.pics', downloadPrefix: 'Tải xuống trên', empty: 'Chưa phát hiện video nào trên trang này.<br>Hãy thử phát video trực tiếp.',
        download: 'Tải xuống', copy: 'Sao chép', open: 'Mở', copied: 'Đã sao chép!', copy_link: 'Sao chép liên kết', open_new_tab: 'Mở trong tab mới', m3u8: 'Luồng M3U8', video: 'Tệp Video',
        paste_url: 'Dán URL video hoặc M3U8 vào đây...',
        invalid_url: 'Vui lòng nhập URL hợp lệ',
        rate_us: 'Đánh giá chúng tôi',
        rating_title: 'Bạn thích LightDownload chứ?',
        rating_text: 'Hãy ủng hộ chúng tôi bằng cách đánh giá 5 sao!',
        rate_now: 'Đánh giá ngay',
        maybe_later: 'Để sau'
    },
    'pt': {
        minSize: 'Tam. mín:', visitSite: 'Visitar mudi.pics', downloadPrefix: 'Baixar em', empty: 'Nenhum vídeo detectado nesta página ainda.<br>Tente reproduzir o vídeo diretamente.',
        download: 'Baixar', copy: 'Copiar', open: 'Abrir', copied: 'Copiado!', copy_link: 'Copiar Link', open_new_tab: 'Abrir em Nova Aba', m3u8: 'Stream M3U8', video: 'Arquivo de Vídeo',
        paste_url: 'Cole o URL do vídeo ou M3U8 aqui...',
        invalid_url: 'Por favor, insira um URL válido',
        rate_us: 'Avalie-nos',
        rating_title: 'Gostando do LightDownload?',
        rating_text: 'Ajude-nos com uma avaliação de 5 estrelas!',
        rate_now: 'Avaliar agora',
        maybe_later: 'Talvez depois'
    },
    'pt-BR': {
        minSize: 'Tam. mín:', visitSite: 'Visitar mudi.pics', downloadPrefix: 'Baixar em', empty: 'Nenhum vídeo detectado nesta página ainda.<br>Tente reproduzir o vídeo diretamente.',
        download: 'Baixar', copy: 'Copiar', open: 'Abrir', copied: 'Copiado!', copy_link: 'Copiar Link', open_new_tab: 'Abrir em Nova Aba', m3u8: 'Stream M3U8', video: 'Arquivo de Vídeo',
        paste_url: 'Cole o URL do vídeo ou M3U8 aqui...',
        invalid_url: 'Por favor, insira um URL válido',
        rate_us: 'Avalie-nos',
        rating_title: 'Gostando do LightDownload?',
        rating_text: 'Ajude-nos com uma avaliação de 5 estrelas!',
        rate_now: 'Avaliar agora',
        maybe_later: 'Talvez depois'
    },
    'pt-PT': {
        minSize: 'Tam. mín:', visitSite: 'Visitar mudi.pics', downloadPrefix: 'Baixar em', empty: 'Nenhum vídeo detectado nesta página ainda.<br>Tente reproduzir o vídeo diretamente.',
        download: 'Baixar', copy: 'Copiar', open: 'Abrir', copied: 'Copiado!', copy_link: 'Copiar Link', open_new_tab: 'Abrir em Nova Aba', m3u8: 'Stream M3U8', video: 'Arquivo de Vídeo',
        paste_url: 'Cole o URL do vídeo ou M3U8 aqui...',
        invalid_url: 'Por favor, insira um URL válido',
        rate_us: 'Avalie-nos',
        rating_title: 'Gostando do LightDownload?',
        rating_text: 'Ajude-nos com uma avaliação de 5 estrelas!',
        rate_now: 'Avaliar agora',
        maybe_later: 'Talvez depois'
    },
    'de': {
        minSize: 'Min. Größe:', visitSite: 'mudi.pics besuchen', downloadPrefix: 'Herunterladen auf', empty: 'Noch keine Videos auf dieser Seite erkannt.<br>Versuchen Sie, das Video direkt abzuspielen.',
        download: 'Download', copy: 'Kopieren', open: 'Öffnen', copied: 'Kopiert!', copy_link: 'Link kopieren', open_new_tab: 'In neuem Tab öffnen', m3u8: 'M3U8 Stream', video: 'Videodatei',
        paste_url: 'Video- oder M3U8-URL hier einfügen...',
        invalid_url: 'Bitte geben Sie eine gültige URL ein',
        rate_us: 'Bewerten Sie uns',
        rating_title: 'Gefällt Ihnen LightDownload?',
        rating_text: 'Unterstützen Sie uns mit einer 5-Sterne-Bewertung!',
        rate_now: 'Jetzt bewerten',
        maybe_later: 'Später vielleicht'
    },
    'fr': {
        minSize: 'Taille min. :', visitSite: 'Visiter mudi.pics', downloadPrefix: 'Télécharger sur', empty: 'Aucune vidéo détectée sur cette page pour le moment.<br>Essayez de lire la vidéo directement.',
        download: 'Télécharger', copy: 'Copier', open: 'Ouvrir', copied: 'Copié !', copy_link: 'Copier le lien', open_new_tab: 'Ouvrir dans un nouvel onglet', m3u8: 'Flux M3U8', video: 'Fichier Vidéo',
        paste_url: 'Coller l\'URL de la vidéo ou du M3U8 ici...',
        invalid_url: 'Veuillez saisir une URL valide',
        rate_us: 'Notez-nous',
        rating_title: 'Vous aimez LightDownload ?',
        rating_text: 'Soutenez-nous en nous donnant 5 étoiles !',
        rate_now: 'Noter maintenant',
        maybe_later: 'Plus tard'
    },
    'it': {
        minSize: 'Dim. min:', visitSite: 'Visita mudi.pics', downloadPrefix: 'Scarica su', empty: 'Nessun video rilevato su questa pagina.<br>Prova a riprodurre il video direttamente.',
        download: 'Scarica', copy: 'Copia', open: 'Apri', copied: 'Copiato!', copy_link: 'Copia link', open_new_tab: 'Apri in una nuova scheda', m3u8: 'Streaming M3U8', video: 'File video',
        paste_url: 'Incolla l\'URL del video o M3U8 qui...',
        invalid_url: 'Si prega di inserire un URL valido',
        rate_us: 'Valutaci',
        rating_title: 'Ti piace LightDownload?',
        rating_text: 'Sostienici con una valutazione a 5 stelle!',
        rate_now: 'Valuta ora',
        maybe_later: 'Forse più tardi'
    },
    'no': {
        minSize: 'Min. størrelse:', visitSite: 'Besøk mudi.pics', downloadPrefix: 'Last ned på', empty: 'Ingen videoer oppdaget på denne siden ennå.<br>Prөv å spille av videoen direkte.',
        download: 'Last ned', copy: 'Kopier', open: 'Åpne', copied: 'Kopiert!', copy_link: 'Kopier lenke', open_new_tab: 'Åpne i ny fane', m3u8: 'M3U8-strøm', video: 'Videofil',
        paste_url: 'Lim inn video- eller M3U8-URL her...',
        invalid_url: 'Vennligst oppgi en gyldig URL',
        rate_us: 'Vurder oss',
        rating_title: 'Liker du LightDownload?',
        rating_text: 'Støtt oss med en 5-stjerners vurdering!',
        rate_now: 'Vurder nå',
        maybe_later: 'Kanskje senere'
    },
    'fi': {
        minSize: 'Vähimmäiskoko:', visitSite: 'Käy mudi.pics', downloadPrefix: 'Lataa kohteessa', empty: 'Tältä sivulta ei ole vielä löytynyt videoita.<br>Kokeile toistaa video suoraan.',
        download: 'Lataa', copy: 'Kopioi', open: 'Avaa', copied: 'Kopioitu!', copy_link: 'Kopioi linkki', open_new_tab: 'Avau uudessa välilehdessä', m3u8: 'M3U8-striimi', video: 'Videotiedosto',
        paste_url: 'Liitä videon tai M3U8:n URL tänne...',
        invalid_url: 'Anna kelvollinen URL-osoite',
        rate_us: 'Arvostele meidät',
        rating_title: 'Pidätkö LightDownloadista?',
        rating_text: 'Tue meitä 5 tähden arvostelulla!',
        rate_now: 'Arvostele nyt',
        maybe_later: 'Ehkä myöhemmin'
    },
    'sv': {
        minSize: 'Min. storlek:', visitSite: 'Besök mudi.pics', downloadPrefix: 'Ladda ner på', empty: 'Inga videor har hittats på den här sidan än.<br>Prova att spela upp videon direkt.',
        download: 'Ladda ner', copy: 'Kopiera', open: 'Öppna', copied: 'Kopierad!', copy_link: 'Kopiera länk', open_new_tab: 'Öppna i ny flik', m3u8: 'M3U8-ström', video: 'Videofil',
        paste_url: 'Klistra in video- eller M3U8-URL här...',
        invalid_url: 'Ange en giltig URL-adress',
        rate_us: 'Betygsätt oss',
        rating_title: 'Gillar du LightDownload?',
        rating_text: 'Stöd oss med ett 5-stjärnigt betyg!',
        rate_now: 'Betygsätt nu',
        maybe_later: 'Kanske senare'
    },
    'da': {
        minSize: 'Min. størrelse:', visitSite: 'Besøg mudi.pics', downloadPrefix: 'Download på', empty: 'Ingen videoer fundet på denne side endnu.<br>Prøv at afspille videoen direkte.',
        download: 'Download', copy: 'Kopier', open: 'Åbn', copied: 'Kopieret!', copy_link: 'Kopiér link', open_new_tab: 'Åbn i ny fane', m3u8: 'M3U8 Stream', video: 'Videofil',
        paste_url: 'Indsæt video- eller M3U8-URL her...',
        invalid_url: 'Indtast venligst en gyldig URL',
        rate_us: 'Bedøm os',
        rating_title: 'Kan du lide LightDownload?',
        rating_text: 'Støt os med en 5-stjernet bedømmelse!',
        rate_now: 'Bedøm nu',
        maybe_later: 'Måske senere'
    },
    'el': {
        minSize: 'Ελάχ. μέγεθος:', visitSite: 'mudi.pics', downloadPrefix: 'Λήψη σε', empty: 'Δεν εντοπίστηκαν βίντεο σε αυτή τη σελίδα ακόμα.<br>Δοκιμάστεια παίξετε το βίντεο.',
        download: 'Λήψη', copy: 'Αντιγραφή', open: 'Άνοιγμα', copied: 'Αντιγράφηκε!', copy_link: 'Αντιγραφή συνδέσμου', open_new_tab: 'Άνοιγμα σε νέα καρτέλα', m3u8: 'Ροή M3U8', video: 'Αρχείο βίντεο',
        paste_url: 'Επικολλήστε τη διεύθυνση URL βίντεο ή M3U8 εδώ...',
        invalid_url: 'Παρακαλώ εισάγετε μια έγκυρη διεύθυνση URL',
        rate_us: 'Βαθμολογήστε μας',
        rating_title: 'Σας αρέσει το LightDownload;',
        rating_text: 'Υποστηρίξτε μας με μια βαθμολογία 5 αστέρων!',
        rate_now: 'Βαθμολογήστε τώρα',
        maybe_later: 'Ίσως αργότερα'
    },
    'tr': {
        minSize: 'Min. Boyut:', visitSite: 'mudi.pics ziyaret et', downloadPrefix: 'Şurada indir:', empty: 'Bu sayfada henüz video algılanmadı.<br>Videoyu doğrudan oynatmayı deneyin.',
        download: 'İndir', copy: 'Kopyala', open: 'Aç', copied: 'Kopyalandı!', copy_link: 'Bağlantıyı Kopyala', open_new_tab: 'Yeni Sekmede Aç', m3u8: 'M3U8 Akışı', video: 'Video Dosyası',
        paste_url: 'Video veya M3U8 URL\'sini buraya yapıştırın...',
        invalid_url: 'Lütfen geçerli bir URL girin',
        rate_us: 'Bizi Oylayın',
        rating_title: 'LightDownload\'dan memnun musunuz?',
        rating_text: 'Bizi 5 yıldızlı bir oylamayla destekleyin!',
        rate_now: 'Şimdi Oyla',
        maybe_later: 'Belki sonra'
    },
    'ru': {
        minSize: 'Мин. размер:', visitSite: 'Посетить mudi.pics', downloadPrefix: 'Скачать на', empty: 'Видео на этой странице пока не обнаружены.<br>Попробуйте воспроизвести видео напрямую.',
        download: 'Скачать', copy: 'Копировать', open: 'Открыть', copied: 'Скопировано!', copy_link: 'Копировать ссылку', open_new_tab: 'Открыть в новой вкладке', m3u8: 'M3U8 поток', video: 'Видеофайл',
        paste_url: 'Вставьте URL-адрес видео или M3U8 здесь...',
        invalid_url: 'Пожалуйста, введите корректный URL',
        rate_us: 'Оцените нас',
        rating_title: 'Нравится LightDownload?',
        rating_text: 'Поддержите нас 5-звездочным рейтингом!',
        rate_now: 'Оценить сейчас',
        maybe_later: 'Возможно, позже'
    },
    'hi': {
        minSize: 'न्यूनतम आकार:', visitSite: 'mudi.pics पर जाएं', downloadPrefix: 'डाउनलोड करें', empty: 'इस पृष्ठ पर अभी तक कोई वीडियो नहीं मिला है।<br>सीधे वीडियो चलाने का प्रयास करें।',
        download: 'डाउनलोड', copy: 'कॉपी करें', open: 'खोलें', copied: 'कॉपी हो गया!', copy_link: 'लिंक कॉपी करें', open_new_tab: 'नए टैब में खोलें', m3u8: 'M3U8 स्ट्रीम', video: 'वीडियो फ़ाइल',
        paste_url: 'वीडियो या M3U8 URL यहाँ पेस्ट करें...',
        invalid_url: 'कृपया एक मान्य URL दर्ज करें',
        rate_us: 'हमें रेट करें',
        rating_title: 'क्या आप LightDownload का आनंद ले रहे हैं?',
        rating_text: '5-स्टार रेटिंग देकर हमारा समर्थन करें!',
        rate_now: 'अभी रेट करें',
        maybe_later: 'शायद बाद में'
    },
    'th': {
        minSize: 'ขนาดขั้นต่ำ:', visitSite: 'เยี่ยมชม mudi.pics', downloadPrefix: 'ดาวน์โหลดที่', empty: 'ยังตรวจไม่พบวิดีโอในหน้านี้<br>ลองเล่นวิดีโอโดยตรง',
        download: 'ดาวน์โหลด', copy: 'คัดลอก', open: 'เปิด', copied: 'คัดลอกแล้ว!', copy_link: 'คัดลอกลิงก์', open_new_tab: 'เปิดในแท็บใหม่', m3u8: 'สตรีม M3U8', video: 'ไฟล์วิดีโอ',
        paste_url: 'วาง URL วิดีโอหรือ M3U8 ที่นี่...',
        invalid_url: 'โปรดป้อน URL ที่ถูกต้อง',
        rate_us: 'ให้คะแนนเรา',
        rating_title: 'สนุกกับการใช้ LightDownload ไหม?',
        rating_text: 'สนับสนุนเราด้วยการให้คะแนน 5 ดาว!',
        rate_now: 'ให้คะแนนตอนนี้',
        maybe_later: 'ไว้ทีหลัง'
    },
    'ko': {
        minSize: '최소 크기:', visitSite: 'mudi.pics 방문', downloadPrefix: '다운로드:', empty: '이 페이지에서 아직 감지된 동영상이 없습니다.<br>동영상을 직접 재생해 보세요.',
        download: '다운로드', copy: '복사', open: '열기', copied: '복사됨!', copy_link: '링크 복사', open_new_tab: '새 탭에서 열기', m3u8: 'M3U8 스트림', video: '동영상 파일',
        paste_url: '여기에 동영상 또는 M3U8 URL을 붙여넣으세요...',
        invalid_url: '올바른 URL을 입력하세요',
        rate_us: '별점 주기',
        rating_title: 'LightDownload가 마음에 드시나요?',
        rating_text: '별 5개 평점으로 저희를 응원해주세요!',
        rate_now: '지금 평가하기',
        maybe_later: '나중에'
    },
    'ro': {
        minSize: 'Dim. min:', visitSite: 'Vizitați mudi.pics', downloadPrefix: 'Descărcați pe', empty: 'Nu au fost detectate videoclipuri.<br>Încercați să redați videoclipul direct.',
        download: 'Descărcați', copy: 'Copiați', open: 'Deschideți', copied: 'Copiat!', copy_link: 'Copiați linkul', open_new_tab: 'Deschideți în filă nouă', m3u8: 'Stream M3U8', video: 'Fișier video',
        paste_url: 'Lipiți adresa URL a videoclipului sau M3U8 aici...',
        invalid_url: 'Vă rugăm să introduceți o adresă URL validă',
        rate_us: 'Evaluează-ne',
        rating_title: 'Îți place LightDownload?',
        rating_text: 'Susține-ne cu o evaluare de 5 stele!',
        rate_now: 'Evaluează acum',
        maybe_later: 'Poate mai târziu'
    },
    'pl': {
        minSize: 'Min. rozmiar:', visitSite: 'Odwiedź mudi.pics', downloadPrefix: 'Pobierz na', empty: 'Na tej stronie nie wykryto jeszcze żadnych filmów.<br>Spróbuj odtworzyć film bezpośrednio.',
        download: 'Pobierz', copy: 'Kopiuj', open: 'Otwórz', copied: 'Skopiowano!', copy_link: 'Kopiuj link', open_new_tab: 'Otwórz w nowej karcie', m3u8: 'Strumień M3U8', video: 'Plik wideo',
        paste_url: 'Wklej tutaj URL wideo lub M3U8...',
        invalid_url: 'Wprowadź prawidłowy adres URL',
        rate_us: 'Oceń nas',
        rating_title: 'Podoba Ci się LightDownload?',
        rating_text: 'Wesprzyj nas 5-gwiazdkową oceną!',
        rate_now: 'Oceń teraz',
        maybe_later: 'Może później'
    },
    'ga': {
        minSize: 'Íosmhéid:', visitSite: 'Cuairt mudi.pics', downloadPrefix: 'Íoslódáil ar', empty: 'Níor aimsíodh aon fhíseáin fós.<br>Déan iarracht an fhíseán a sheinn go díreach.',
        download: 'Íoslódáil', copy: 'Cóipeáil', open: 'Oscail', copied: 'Cóipeáilte!', copy_link: 'Cóipeáil nasc', open_new_tab: 'Oscail i gcluaisín nua', m3u8: 'Sruth M3U8', video: 'Comhad físe',
        paste_url: 'Greamaigh URL físe nó M3U8 anseo...',
        invalid_url: 'Cuir isteach URL bailí le do thoil',
        rate_us: 'Tabhair rátáil dúinn',
        rating_title: 'An mbaineann tú taitneamh as LightDownload?',
        rating_text: 'Tacaigh linn le rátáil 5 réalta!',
        rate_now: 'Rátáil anois',
        maybe_later: 'Bhéidir níos déanaí'
    },
    'et': {
        minSize: 'Min suurus:', visitSite: 'Külasta mudi.pics', downloadPrefix: 'Laadi alla', empty: 'Sellelt lehelt pole vielä videoid leitud.<br>Proovige videot otse mängida.',
        download: 'Laadi alla', copy: 'Kopeeri', open: 'Ava', copied: 'Kopeeritud!', copy_link: 'Kopeeri link', open_new_tab: 'Ava uuel vahelehel', m3u8: 'M3U8 voog', video: 'Videofail',
        paste_url: 'Kleebi siia video või M3U8 URL...',
        invalid_url: 'Palun sisestage kehtiv URL',
        rate_us: 'Hinda meid',
        rating_title: 'Kas naudid LightDownloadi?',
        rating_text: 'Toeta meid 5-tärni hinnanguga!',
        rate_now: 'Hinda nüüd',
        maybe_later: 'Võib-olla hiljem'
    },
    'bg': {
        minSize: 'Мин. размер:', visitSite: 'mudi.pics', downloadPrefix: 'Изтегляне в', empty: 'Все още не са открити видеоклипове.<br>Опитайте да пуснете видеоклипа директно.',
        download: 'Изтегляне', copy: 'Копиране', open: 'Отваряне', copied: 'Копирано!', copy_link: 'Копиране на връзка', open_new_tab: 'Отваряне в нов раздел', m3u8: 'M3U8 поток', video: 'Видео файл',
        paste_url: 'Поставете URL адреса на видеоклипа или M3U8 тук...',
        invalid_url: 'Моля, въведете валиден URL адрес',
        rate_us: 'Оценете ни',
        rating_title: 'Харесва ли ви LightDownload?',
        rating_text: 'Подкрепете ни с оценка от 5 звезди!',
        rate_now: 'Оценете сега',
        maybe_later: 'Може би по-късно'
    },
    'cs': {
        minSize: 'Min. velikost:', visitSite: 'Navštívit mudi.pics', downloadPrefix: 'Stáhnout na', empty: 'Na této stránce zatím nebyla zjištěna žádná videa.<br>Zkuste video přehrát přímo.',
        download: 'Stáhnout', copy: 'Kopírovat', open: 'Otevřít', copied: 'Zkopírováno!', copy_link: 'Kopírovat odkaz', open_new_tab: 'Otevřít na nové kartě', m3u8: 'Stream M3U8', video: 'Video soubor',
        paste_url: 'Sem vložte adresu URL videa nebo M3U8...',
        invalid_url: 'Zadejte prosím platnou adresu URL',
        rate_us: 'Ohodnoťte nás',
        rating_title: 'Baví vás LightDownload?',
        rating_text: 'Podpořte nás 5hvězdičkovým hodnocením!',
        rate_now: 'Hodnotit nyní',
        maybe_later: 'Možná později'
    },
    'ms': {
        minSize: 'Saiz min:', visitSite: 'Lawat mudi.pics', downloadPrefix: 'Muat turun di', empty: 'Tiada video dikesan di halaman ini lagi.<br>Cuba mainkan video secara langsung.',
        download: 'Muat turun', copy: 'Salin', open: 'Buka', copied: 'Disalin!', copy_link: 'Salin Pautan', open_new_tab: 'Buka dalam tab baru', m3u8: 'Strim M3U8', video: 'Fail Video',
        paste_url: 'Tampal URL video atau M3U8 di sini...',
        invalid_url: 'Sila masukkan URL yang sah',
        rate_us: 'Nilaikan Kami',
        rating_title: 'Suka menggunakan LightDownload?',
        rating_text: 'Sokong kami dengan penilaian 5 bintang!',
        rate_now: 'Nilai Sekarang',
        maybe_later: 'Mungkin Kemudian'
    },
    'sk': {
        minSize: 'Min. veľkosť:', visitSite: 'Navštíviť mudi.pics', downloadPrefix: 'Stiahnuť na', empty: 'Na tejto stránce zatiaľ neboli zistené žiadne videá.<br>Skúste video prehrať priamo.',
        download: 'Stiahnuť', copy: 'Kopírovať', open: 'Otvoriť', copied: 'Skopírované!', copy_link: 'Kopírovať odkaz', open_new_tab: 'Otvoriť na novej karte', m3u8: 'Stream M3U8', video: 'Video súbor',
        paste_url: 'Sem vložte adresu URL videa alebo M3U8...',
        invalid_url: 'Zadajte platnú adresu URL',
        rate_us: 'Ohodnoťte nás',
        rating_title: 'Páči sa vám LightDownload?',
        rating_text: 'Podporte nás 5-hviezdičkovým hodnotením!',
        rate_now: 'Hodnotiť teraz',
        maybe_later: 'Možno neskôr'
    },
    'hu': {
        minSize: 'Min. méret:', visitSite: 'mudi.pics', downloadPrefix: 'Letöltés itt:', empty: 'Még nem észleltünk videót ezen az oldalon.<br>Próbálja meg lejátszani a videót.',
        download: 'Letöltés', copy: 'Másolás', open: 'Megnyitás', copied: 'Másolva!', copy_link: 'Link másolása', open_new_tab: 'Megnyitás új lapon', m3u8: 'M3U8 stream', video: 'Videofájl',
        paste_url: 'Illessze be a videó vagy az M3U8 URL-jét ide...',
        invalid_url: 'Kérjük, adjon meg egy érvényes URL-t',
        rate_us: 'Értékeljen minket',
        rating_title: 'Tetszik a LightDownload?',
        rating_text: 'Támogasson minket egy 5 csillagos értékeléssel!',
        rate_now: 'Értékelés most',
        maybe_later: 'Talán később'
    },
    'id': {
        minSize: 'Ukuran min:', visitSite: 'Kunjungi mudi.pics', downloadPrefix: 'Unduh di', empty: 'Belum ada video yang terdeteksi di halaman ini.<br>Coba putar video secara langsung.',
        download: 'Unduh', copy: 'Salin', open: 'Buka', copied: 'Tersalin!', copy_link: 'Salin Tautan', open_new_tab: 'Buka di tab baru', m3u8: 'Streaming M3U8', video: 'File Video',
        paste_url: 'Tempel URL video atau M3U8 di sini...',
        invalid_url: 'Harap masukkan URL yang valid',
        rate_us: 'Nilai Kami',
        rating_title: 'Menikmati LightDownload?',
        rating_text: 'Dukung kami dengan rating bintang 5!',
        rate_now: 'Nilai Sekarang',
        maybe_later: 'Mungkin Nanti'
    },
    'fil': {
        minSize: 'Min. Size:', visitSite: 'Bisitahin ang mudi.pics', downloadPrefix: 'I-download sa', empty: 'Wala pang nakitang video sa pahinang ito.<br>Subukang i-play ang video nang direkta.',
        download: 'I-download', copy: 'Kopyahin', open: 'Buksan', copied: 'Nakopya na!', copy_link: 'Kopyahin ang Link', open_new_tab: 'Buksan sa Bagong Tab', m3u8: 'M3U8 Stream', video: 'File ng Video',
        paste_url: 'I-paste ang URL ng video o M3U8 dito...',
        invalid_url: 'Mangyaring magpasok ng valid na URL',
        rate_us: 'I-rate Kami',
        rating_title: 'Nagugustuhan mo ba ang LightDownload?',
        rating_text: 'Suportahan kami sa pamamagitan ng 5-star rating!',
        rate_now: 'I-rate Ngayon',
        maybe_later: 'Susunod na lang'
    },
};

function getLanguage() {
    const navLang = navigator.language; // e.g., "en-US", "zh-CN"
    // Exact match
    if (supportedLangs.includes(navLang)) return navLang;
    // Prefix match (e.g. "pt-BR" -> "pt" if "pt" is supported; or "es-419" -> "es")
    const shortLang = navLang.split('-')[0];
    if (supportedLangs.includes(shortLang)) return shortLang;
    return 'default';
}

function getStoreUrl() {
    const lang = getLanguage();
    if (lang === 'default') return STORE_URL;
    return `${STORE_URL}?hl=${lang}`;
}

const currentLang = getLanguage();

function getTranslation(key) {
    const langSet = translations[currentLang] || translations['default'];
    return langSet[key] || translations['default'][key];
}

document.addEventListener('DOMContentLoaded', async () => {
    // I18n Init
    const t = getTranslation;
    const isDefaultLang = currentLang === 'default';
    const linkSuffix = isDefaultLang ? '' : `/${currentLang}`;

    // Update Visit Link
    const visitLink = document.querySelector('.site-link-btn');
    if (visitLink) {
        visitLink.href = url + `${linkSuffix}`;
        // Preserve icon
        const icon = visitLink.innerHTML.match(/<svg[\s\S]*?<\/svg>/)[0];
        visitLink.innerHTML = `${icon} ${t('visitSite')}`;
    }

    // Translate Static UI
    document.querySelectorAll('[data-i18n]').forEach(el => {
        const key = el.getAttribute('data-i18n');
        if (key) el.innerText = t(key);
    });

    document.querySelectorAll('[data-i18n-title]').forEach(el => {
        const key = el.getAttribute('data-i18n-title');
        if (key) el.setAttribute('title', t(key));
    });

    document.querySelectorAll('[data-i18n-placeholder]').forEach(el => {
        const key = el.getAttribute('data-i18n-placeholder');
        if (key) el.setAttribute('placeholder', t(key));
    });

    // Rating Logic Init
    const rateLink = document.querySelector('.rate-link');
    if (rateLink) {
        rateLink.addEventListener('click', (e) => {
            e.preventDefault();
            chrome.tabs.create({ url: getStoreUrl() });
        });
    }

    const ratingBanner = document.getElementById('rating-banner');
    const maybeLaterBtn = document.querySelector('.maybe-later-btn');
    const rateNowBtn = document.querySelector('.rate-now-btn');

    chrome.storage.local.get(['downloadCount', 'isRated', 'lastDismissed'], (data) => {
        const count = data.downloadCount || 0;
        const isRated = data.isRated || false;
        const lastDismissed = data.lastDismissed || 0;
        const now = Date.now();
        //当用户成功下载 3 次后，会自动弹出求好评的横幅。用户可以选择“现在去好评”或“以后再说”（点击后会隐藏一周）
        const oneWeek = 7 * 24 * 60 * 60 * 1000;

        if (!isRated && count >= 3 && (now - lastDismissed > oneWeek)) {
            ratingBanner.style.display = 'block';
        }
    });

    maybeLaterBtn.addEventListener('click', () => {
        ratingBanner.style.display = 'none';
        chrome.storage.local.set({ lastDismissed: Date.now() });
    });

    rateNowBtn.addEventListener('click', () => {
        ratingBanner.style.display = 'none';
        chrome.storage.local.set({ isRated: true });
        chrome.tabs.create({ url: getStoreUrl() });
    });

    function incrementDownloadCount() {
        chrome.storage.local.get('downloadCount', (data) => {
            const newCount = (data.downloadCount || 0) + 1;
            chrome.storage.local.set({ downloadCount: newCount });
        });
    }

    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
    const videoList = document.getElementById('video-list');
    const minSizeInput = document.getElementById('min-size-input');
    let currentVideos = [];

    // Load saved setting
    chrome.storage.local.get('minSize', (data) => {
        if (data.minSize !== undefined) {
            minSizeInput.value = data.minSize;
        }
    });

    minSizeInput.addEventListener('change', () => {
        const val = parseFloat(minSizeInput.value);
        if (val < 0) minSizeInput.value = 0;
        chrome.storage.local.set({ minSize: minSizeInput.value }, () => {
            // Re-request the videos from background to get the new filtered list
            chrome.runtime.sendMessage({ action: 'GET_VIDEOS', tabId: tab.id }, (response) => {
                if (response && response.videos) {
                    currentVideos = response.videos;
                    renderVideos(currentVideos);
                }
            });
        });
    });

    // Request videos from background
    chrome.runtime.sendMessage({ action: 'GET_VIDEOS', tabId: tab.id }, (response) => {
        if (response && response.videos && response.videos.length > 0) {
            currentVideos = response.videos;
            renderVideos(currentVideos);
        } else {
            videoList.innerHTML = `<div class="empty-state">${t('empty')}</div>`;
        }
    });

    const downloadAction = () => {
        const videoUrlInput = document.getElementById("videoUrl");
        const videoUrl = videoUrlInput.value.trim();

        if (!videoUrl) return;

        // Simple validation
        try {
            new URL(videoUrl);
        } catch (e) {
            alert(t('invalid_url'));
            return;
        }

        const TARGET_DOMAIN = url + `${linkSuffix}`;
        const encodedUrl = encodeURIComponent(videoUrl);
        const targetUrl = TARGET_DOMAIN + `?url=${encodedUrl}`;

        chrome.runtime.sendMessage({
            action: 'DOWNLOAD_AND_BYPASS',
            payload: {
                videoUrl: videoUrl,
                targetUrl: targetUrl,
                referer: tab.url
            }
        });
        incrementDownloadCount();
    };

    document.getElementById('downloadVideo').addEventListener('click', downloadAction);

    document.getElementById('videoUrl').addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            downloadAction();
        }
    });

    // Global Action Buttons (for direct download input)
    document.querySelector('.video-actions .copy-btn').addEventListener('click', () => {
        const videoUrl = document.getElementById("videoUrl").value.trim();
        if (!videoUrl) return;
        navigator.clipboard.writeText(videoUrl).then(() => {
            const btn = document.querySelector('.video-actions .copy-btn');
            const originalHTML = btn.innerHTML;
            btn.innerText = t('copied');
            setTimeout(() => btn.innerHTML = originalHTML, 1500);
        });
    });

    document.querySelector('.video-actions .open-btn').addEventListener('click', () => {
        const videoUrl = document.getElementById("videoUrl").value.trim();
        if (!videoUrl) return;
        chrome.tabs.create({ url: videoUrl });
    });

    function renderVideos(videos) {
        videoList.innerHTML = '';
        if (videos.length === 0) {
            videoList.innerHTML = `<div class="empty-state">${t('empty')}</div>`;
            return;
        }

        videos.forEach((video) => {
            const isM3u8 = video.url.toLowerCase().split('?')[0].endsWith('.m3u8') ||
                (video.type && video.type.includes('mpegurl'));

            const label = isM3u8 ? t('m3u8') : t('video');
            const sizeText = video.size ? ` • ${(video.size / 1024 / 1024).toFixed(2)} MB` : '';

            const item = document.createElement('div');
            item.className = 'video-item';

            item.innerHTML = `
                <div class="video-info">
                  <div class="video-type">${label}${sizeText}</div>
                  <div class="video-url" title="${video.url}">${video.url}</div>
                </div>
                <button class="download-btn">
                  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                  </svg>
                  ${t('downloadPrefix')} mudi.pics
                </button>
                <div class="video-actions">
                  <button class="action-btn copy-btn" title="${t('copy_link')}">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
                    </svg>
                    ${t('copy')}
                  </button>
                  <button class="action-btn open-btn" title="${t('open_new_tab')}">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                    </svg>
                    ${t('open')}
                  </button>
                </div>
              `;

            item.querySelector('.download-btn').addEventListener('click', () => {
                // Construct target URL
                const TARGET_DOMAIN = url + `${linkSuffix}`;
                const encodedUrl = encodeURIComponent(video.url);
                const targetUrl = `${TARGET_DOMAIN}?url=${encodedUrl}`;

                // Use background bypass logic
                chrome.runtime.sendMessage({
                    action: 'DOWNLOAD_AND_BYPASS',
                    payload: {
                        videoUrl: video.url,
                        targetUrl: targetUrl,
                        referer: tab.url
                    }
                });
                incrementDownloadCount();
            });

            item.querySelector('.copy-btn').addEventListener('click', () => {
                navigator.clipboard.writeText(video.url).then(() => {
                    const btn = item.querySelector('.copy-btn');
                    const originalHTML = btn.innerHTML;
                    btn.innerText = t('copied');
                    setTimeout(() => btn.innerHTML = originalHTML, 1500);
                });
            });

            item.querySelector('.open-btn').addEventListener('click', () => {
                chrome.tabs.create({ url: video.url });
            });

            videoList.appendChild(item);
        });
    }
});
